 /* ----------------------------------------------------------------------------
  * Copyright(c) 2000 MERANT. All rights reserved.
  *
  * Description:
  * JNDI Example for the DataDirect JDBC Drivers using the
  * LDAP JNDI provider from Sun Microsystems, Inc.
  *
  * This Example consists of three parts:
  *
  * 1. Set up the environment and create the initial LDAP context.
  * This code is required for both the bind and the lookup of data sources.
  * This is the only part that is different between the two JNDI examples
  * (LDAP and FileSystem).
  *
  * 2. Construct and bind the DataSource. This part is
  * normally performed by an administrator (using a JNDI tool).
  *
  * 3. Look up the data source and establish a connection. Typically,
  * applications that use JNDI to connect to a database contain this code.
  *
  * Remarks:
  * For more information about JNDI, consult "The JNDI Tutorial" at
  * http://www.java.sun.com
  *
  * To do:
  * Adapt this code to your specific environment, it uses SQLServer by default.
  *
  */

import com.merant.datadirect.jdbcx.sqlserver.SQLServerDataSource;
//import com.merant.datadirect.jdbcx.db2.DB2DataSource;
//import com.merant.datadirect.jdbcx.sybase.SybaseDataSource;
//import com.merant.datadirect.jdbcx.informix.InformixDataSource;
import java.util.Hashtable;
import javax.naming.*;
import javax.naming.directory.*;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JNDI_LDAP_Example
{
public static void main(String argv[])
    {
    String name = "cn=MyDatabase"; // The data source will be bound to this name

    try
        {
        /***********************************************************************
         * Part 1. Set up the environment and create the initial LDAP context. *
         ***********************************************************************/
        Hashtable env = new Hashtable();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(Context.PROVIDER_URL, "ldap://servername/ou=orgUnit,o=org");

        System.out.println("Trying to create the naming service initial context");
        Context ctx = new InitialContext(env);


        /****************************************************************
         * Part 2. Construct and bind the DataSource.                   *
         ****************************************************************/

        //SQLServer DataSources
        SQLServerDataSource mds = new SQLServerDataSource();
        mds.setDescription("My SQLServerDataSource");
        mds.setServerName("MyServer");
        mds.setPortNumber(1433);
        mds.setDatabaseName("database");
        mds.setSelectMethod("cursor");

        /*
        //DB2 DataSources
        DB2DataSource mds = new DB2DataSource();
        mds.setDescription("My DB2DataSource");
        mds.setServerName("MyServer");
        mds.setPortNumber(50000);
        mds.setDatabaseName("database");
        mds.setCollectionId("collectionid");
        mds.setPackageName("packageName");
        */

        /*
        //DB2 MVS DataSources
        DB2DataSource mds = new DB2DataSource();
        mds.setDescription("My DB2DataSource");
        mds.setServerName("MyServer");
        mds.setPortNumber(50000);
        mds.setLocationName("location");
        mds.setCollectionId("collectionid");
        mds.setPackageName("packageName");
        */

        /*
        //Sybase DataSources
        SybaseDataSource mds = new SybaseDataSource();
        mds.setDescription("My SybaseDataSource");
        mds.setServerName("MyServer");
        mds.setPortNumber(5000);
        mds.setDatabaseName("database");
        mds.setSelectMethod("direct or cursor");
        */

        /*
        //Informix DataSources
        InformixDataSource mds = new InformixDataSource();
        mds.setDescription("My InformixDataSource");
        mds.setServerName("MyServerHost");
        mds.setPortNumber(5000);
        mds.setInformixServer("MyInformixServer");
        mds.setDatabaseName("database");
        */

        System.out.println("Trying to bind for the naming service");
        ctx.bind(name, mds);


        /******************************************************************
        * Part 3. Look up the data source and establish a connection.     *
        *******************************************************************/
        System.out.println("Checking the JNDI binding");
        DataSource ds = (DataSource) ctx.lookup(name);

        // *** Driver SPECIFIC CODE ***
        // The following code is DataSource Specific.
        // It is only used here to print out the DataSource attributes.
        // Because this code is specific for Your driver, your applications should not
        // contain this code. (If you want to print out the DataSource attributes
        // in your code, you should use Java's reflection capabilities.)

        //SQLServer DataSources
        if (ds instanceof SQLServerDataSource)
            {
            SQLServerDataSource jmds = (SQLServerDataSource) ds;
            System.out.println("description=" + jmds.getDescription());
            System.out.println("serverName=" + jmds.getServerName());
            System.out.println("portNumber=" + jmds.getPortNumber());
            System.out.println("databaseName=" + jmds.getDatabaseName());
            System.out.println("selectMethod=" + jmds.getSelectMethod());
            System.out.println();
            }


        /*
        //DB2 DataSources
        if (ds instanceof DB2DataSource)
            {
            DB2DataSource jmds = (DB2DataSource) ds;
            System.out.println("description=" + jmds.getDescription());
            System.out.println("serverName=" + jmds.getServerName());
            System.out.println("portNumber=" + jmds.getPortNumber());
            System.out.println("databaseName=" + jmds.getDatabaseName());
            System.out.println("packageName=" + jmds.getPackageName());
            System.out.println("collectionId=" + jmds.getCollectionId());
            System.out.println();
            }
        */

        /*
        //DB2 MVS DataSources
        if (ds instanceof DB2DataSource)
            {
            DB2DataSource jmds = (DB2DataSource) ds;
            System.out.println("description=" + jmds.getDescription());
            System.out.println("serverName=" + jmds.getServerName());
            System.out.println("portNumber=" + jmds.getPortNumber());
            System.out.println("locationName=" + jmds.getLocationName());
            System.out.println("packageName=" + jmds.getPackageName());
            System.out.println("collectionId=" + jmds.getCollectionId());
            System.out.println();
            }
        */

        /*
        //Sybase DataSources
        if (ds instanceof SybaseDataSource)
            {
            SybaseDataSource jmds = (SybaseDataSource) ds;
            System.out.println("description=" + jmds.getDescription());
            System.out.println("serverName=" + jmds.getServerName());
            System.out.println("portNumber=" + jmds.getPortNumber());
            System.out.println("databaseName=" + jmds.getDatabaseName());
            System.out.println("selectMethod=" + jmds.getSelectMethod());
            System.out.println();
            }
        */

        /*
        //Informix DataSources
        if (ds instanceof InformixDataSource)
            {
            InformixDataSource jmds = (InformixDataSource) ds;
            System.out.println("description=" + jmds.getDescription());
            System.out.println("serverName=" + jmds.getServerName());
            System.out.println("portNumber=" + jmds.getPortNumber());
            System.out.println("informixServer=" + jmds.getInformixServer());
            System.out.println("databaseName=" + jmds.getDatabaseName());
            System.out.println();
            }
        */

        // *** END OF Driver SPECIFIC CODE.

        // Try to make a connection
        System.out.println("*** Trying to make a connection ***");
        Connection con = ds.getConnection("john", "whatever");
        System.out.println("Connection established");
        con.close();
        System.out.println("Connection closed");
        }
    catch (SQLException se)
        {
        while (se!=null)
            {
            System.out.println("vendor code: " + se.getErrorCode());
            System.out.println("Message:     " + se.getMessage());
            System.out.println("SQLState:    " + se.getSQLState());
            se.printStackTrace();
            se=se.getNextException();
            }
        }
    catch (NamingException ne)
        {
        ne.printStackTrace();
        }
    } // main
} // JNDI_LDAP_Example.java
