#!/bin/ksh 

clear

echo ""
echo "============================================================"
echo "=    Microsoft SQLServer 2000 JDBC Driver Installation     ="
echo "============================================================"
echo ""
echo "Initializing....."
echo ""

ERRCHK=1
INSTALLDIR=`pwd`
TARFILE="$INSTALLDIR/msjdbc.tar"

echo ""
echo "================================================================="
echo "=    Microsoft SQLServer 2000 JDBC Driver License Agreement     ="
echo "================================================================="
echo ""
echo "Press <enter> to view License Agreement."
read DUMMY

more EULA.txt

echo ""
echo "Do you agree to the terms of the License Agreement? <y/n> (y)"

read ANSWER

case $ANSWER in
  "n" | "N" | "No" | "no" | "NO")
	echo "Installation Cancelled by user."
	exit 0
        break;
        ;;
   *)
	echo "Installation proceeding..."
        break;
        ;;
esac

while true
do
	if [ $ERRCHK -ne 0 ] ; then 
		echo ""
		echo "Please enter the installation directory: (/opt/msSQLjdbc)"

		read TARGETDIR

		if [ ! -d "$TARGETDIR" ] ; then
			mkdir -p "$TARGETDIR"
        		ERRCHK="$?"
        		if [ "$ERRCHK" -ne 0 ] ; then
				echo "You do not have permissions to write to this directory"
			fi
		fi
	else
		break
	fi
done

echo ""
echo "Installing Microsoft SQLServer 2000 JDBC Driver...."

cd $TARGETDIR

tar -xf $TARFILE
ERRCHK="$?"
if [ $ERRCHK -ne 0 ] ; then
	echo "There was a problem opening the tar file ($TARFILE)"
	echo "Aborting Installation."
        exit 0
else
	echo "Installation is Complete."
	echo "The Microsoft SQLServer 2000 JDBC Driver is installed in the following location: $TARGETDIR"
fi



